﻿param (
    [Parameter(Mandatory=$true)][string]$ou,
    [Parameter(Mandatory=$true)][string]$zoekgenest
)

[Console]::OutputEncoding = [Text.UTF8Encoding]::UTF8

Import-Module ActiveDirectory

$blnzoekgenest  = [boolean]::Parse($zoekgenest)

if($blnzoekgenest){
    try{
        Get-ADUser -filter * -SearchBase "$ou" -Properties UserPrincipalName |  
        select @{N='UPN';E={$_.UserPrincipalName}} |
        ConvertTo-Json
    }
    catch{
        Write-Host "Fout bij het opvragen van gebruikers in OU $ou"
    }
}
else{
    try{
        Get-ADUser -filter * -SearchBase "$ou" -SearchScope OneLevel -Properties UserPrincipalName |  
        select @{N='UPN';E={$_.UserPrincipalName}} |
        ConvertTo-Json
    }
    catch{
        Write-Host "Fout bij het opvragen van gebruikers in OU $ou"
    }
}